/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.food;

import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.Nutrient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class NutritionStats
implements INBTSerializable<NBTTagCompound> {
    private final LinkedList<FoodData> records = new LinkedList();
    private final float defaultNutritionValue;
    private final float defaultDairyNutritionValue;
    private final float[] nutrients;
    private float averageNutrients;
    private int hungerWindow;

    public NutritionStats(float defaultNutritionValue, float defaultDairyNutritionValue) {
        this.defaultNutritionValue = defaultNutritionValue;
        this.defaultDairyNutritionValue = defaultDairyNutritionValue;
        this.nutrients = new float[5];
        this.hungerWindow = 0;
        this.calculateNutrition();
    }

    public void reset() {
        this.records.clear();
        this.calculateNutrition();
    }

    @Nullable
    public FoodData getMostRecentRecord() {
        return this.records.peekFirst();
    }

    public float getAverageNutrition() {
        return this.averageNutrients;
    }

    public float getNutrient(Nutrient nutrient) {
        return this.nutrients[nutrient.ordinal()];
    }

    public float[] getNutrients() {
        return this.nutrients;
    }

    public void onReceivePacket(float[] nutrients) {
        System.arraycopy(nutrients, 0, this.nutrients, 0, this.nutrients.length);
        this.updateAverageNutrients();
    }

    public void addNutrients(@Nonnull FoodData data) {
        this.records.addFirst(data.copy());
        this.calculateNutrition();
    }

    public void addBuff(@Nonnull FoodData data) {
        FoodData recentFood = this.getMostRecentRecord();
        if (recentFood != null) {
            recentFood.applyBuff(data);
            this.calculateNutrition();
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList recordsNbt = new NBTTagList();
        for (FoodData data : this.records) {
            recordsNbt.func_74742_a((NBTBase)data.serializeNBT());
        }
        nbt.func_74782_a("records", (NBTBase)recordsNbt);
        return nbt;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.records.clear();
            NBTTagList recordsNbt = nbt.func_150295_c("records", 10);
            for (int i = 0; i < recordsNbt.func_74745_c(); ++i) {
                this.records.add(new FoodData(recordsNbt.func_150305_b(i)));
            }
            this.calculateNutrition();
        }
    }

    private void calculateNutrition() {
        Arrays.fill(this.nutrients, 0.0f);
        int runningHungerTotal = 0;
        this.hungerWindow = ConfigTFC.General.PLAYER.nutritionRotationHungerWindow;
        for (int i = 0; i < this.records.size(); ++i) {
            FoodData record = this.records.get(i);
            int nextHunger = record.getHunger() + runningHungerTotal;
            if (nextHunger < this.hungerWindow) {
                this.updateAllNutrients(this.nutrients, j -> this.nutrients[j] + record.getNutrients()[j] * (float)record.getHunger());
                runningHungerTotal = nextHunger;
                continue;
            }
            float actualHunger = this.hungerWindow - runningHungerTotal;
            this.updateAllNutrients(this.nutrients, j -> this.nutrients[j] + record.getNutrients()[j] * actualHunger);
            while (this.records.size() > i + 1) {
                this.records.remove(i + 1);
            }
        }
        this.updateAllNutrients(this.nutrients, j -> this.nutrients[j] / (float)this.hungerWindow);
        if (runningHungerTotal < this.hungerWindow) {
            float defaultModifier = 1.0f - (float)runningHungerTotal / (float)this.hungerWindow;
            for (Nutrient nutrient : Nutrient.values()) {
                if (nutrient == Nutrient.DAIRY) {
                    int n = nutrient.ordinal();
                    this.nutrients[n] = this.nutrients[n] + this.defaultDairyNutritionValue * defaultModifier;
                    continue;
                }
                int n = nutrient.ordinal();
                this.nutrients[n] = this.nutrients[n] + this.defaultNutritionValue * defaultModifier;
            }
        }
        this.updateAllNutrients(this.nutrients, j -> Math.min(1.0f, this.nutrients[j]));
        this.updateAverageNutrients();
    }

    private void updateAverageNutrients() {
        this.averageNutrients = 0.0f;
        for (float nutrient : this.nutrients) {
            this.averageNutrients += nutrient;
        }
        this.averageNutrients /= (float)Nutrient.TOTAL;
    }

    private void updateAllNutrients(float[] array, IntToFloatFunction operator) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = operator.apply(i);
        }
    }

    private static interface IntToFloatFunction {
        public float apply(int var1);
    }
}

